/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import cz.insophy.inplan.sdgraph.MttComputer;
import cz.insophy.inplan.sdgraph.MttEdge;
import cz.insophy.inplan.sdgraph.SdgCrNode;
import cz.insophy.inplan.sdgraph.SdgEdge;
import cz.insophy.inplan.sdgraph.SdgEsaNode;
import cz.insophy.inplan.sdgraph.SdgGarNode;
import cz.insophy.inplan.sdgraph.SdgGorNode;
import cz.insophy.inplan.sdgraph.SdgMatprodNode;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.sdgraph.SdgNodeVisitor;
import cz.insophy.inplan.sdgraph.SdgSrNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class StoreDependencyGraphImpl
implements StoreDependencyGraph {
    private final Superplan superplan;
    ImmutableMap<SupplyRequest, SdgSrNode> srNodes;
    ImmutableMap<ExternalStoreActivity, SdgEsaNode> esaNodes;
    ImmutableMap<GeneralizedOrderRequest, SdgGorNode> gorNodes;
    ImmutableMap<GeneralizedActionRequest, SdgGarNode> garNodes;
    ImmutableMap<CustomerRequest, SdgCrNode> crNodes;
    ImmutableMap<Material, SdgMatprodNode> materialNodes;
    ImmutableList<SdgNode> allNodes;
    ImmutableList<SdgEdge> allEdges;
    private Table<SdgNode, SdgNode, Map<List<MttEdge>, Double>> mtts;

    StoreDependencyGraphImpl(Superplan superplan) {
        this.superplan = superplan;
    }

    @Override
    @Nonnull
    public Superplan getSuperplan() {
        return this.superplan;
    }

    @Override
    @Nonnull
    public Collection<SdgNode> getAllNodes() {
        return this.allNodes;
    }

    @Override
    @Nonnull
    public List<SdgEdge> getAllEdges() {
        return this.allEdges;
    }

    @Override
    @Nonnull
    public SdgSrNode getNode(@Nonnull SupplyRequest sr) {
        SdgSrNode r = this.srNodes.get(sr);
        Preconditions.checkArgument(r != null, "%s is not in graph", (Object)sr);
        return r;
    }

    @Override
    @Nonnull
    public SdgEsaNode getNode(@Nonnull ExternalStoreActivity esa) {
        SdgEsaNode r = this.esaNodes.get(esa);
        Preconditions.checkArgument(r != null, "%s is not in graph", (Object)esa);
        return r;
    }

    @Override
    @Nonnull
    public SdgGorNode getNode(@Nonnull GeneralizedOrderRequest gor) {
        SdgGorNode r = this.gorNodes.get(gor);
        Preconditions.checkArgument(r != null, "%s is not in graph", (Object)gor);
        return r;
    }

    @Override
    @Nonnull
    public SdgGarNode getNode(@Nonnull GeneralizedActionRequest gar) {
        SdgGarNode r = this.garNodes.get(gar);
        Preconditions.checkArgument(r != null, "%s is not in graph", (Object)gar);
        return r;
    }

    @Override
    @Nonnull
    public SdgCrNode getNode(@Nonnull CustomerRequest cr) {
        SdgCrNode r = this.crNodes.get(cr);
        Preconditions.checkArgument(r != null, "%s is not in graph", (Object)cr);
        return r;
    }

    @Override
    @Nonnull
    public SdgMatprodNode getNode(@Nonnull Material mat) {
        SdgMatprodNode r = this.materialNodes.get(mat);
        Preconditions.checkArgument(r != null, "%s is not in graph", (Object)mat);
        return r;
    }

    private static Set<TopoNodeWrapper> createWrappers(Collection<SdgNode> nodes, StoreDependencyGraph.Direction direction) {
        TopoSortKeyExtractor extractor = new TopoSortKeyExtractor();
        ImmutableMap wrappers = Maps.toMap(nodes, n -> new TopoNodeWrapper((SdgNode)n, extractor));
        ArrayList<TopoNodeWrapper> tmpNeighbors = Lists.newArrayList();
        for (TopoNodeWrapper nw : wrappers.values()) {
            Set<SdgNode> neighbors;
            if (direction == StoreDependencyGraph.Direction.TO_FINALS) {
                neighbors = nw.node.getDirectSuccessors();
            } else if (direction == StoreDependencyGraph.Direction.TO_SOURCES) {
                neighbors = nw.node.getDirectPredecessors();
            } else {
                throw new IllegalStateException();
            }
            tmpNeighbors.clear();
            for (SdgNode neighbor : neighbors) {
                TopoNodeWrapper neighborWrapper = (TopoNodeWrapper)wrappers.get(neighbor);
                if (neighborWrapper == null) continue;
                tmpNeighbors.add(neighborWrapper);
            }
            nw.setNeighbors(tmpNeighbors);
        }
        return Sets.newHashSet(wrappers.values());
    }

    @Override
    public List<StoreDependencyGraph.NodeLevel> topologicallySortNodes(Collection<SdgNode> nodes, StoreDependencyGraph.Direction direction) {
        TopoNodeWrapperComparator comparator = new TopoNodeWrapperComparator(direction);
        PriorityQueue<TopoNodeWrapper> topQueue = new PriorityQueue<TopoNodeWrapper>(comparator);
        Set<TopoNodeWrapper> wrappers = StoreDependencyGraphImpl.createWrappers(nodes, direction);
        Iterator<TopoNodeWrapper> wrapperIt = wrappers.iterator();
        while (wrapperIt.hasNext()) {
            TopoNodeWrapper nw = wrapperIt.next();
            if (nw.depsCnt != 0) continue;
            topQueue.add(nw);
            wrapperIt.remove();
        }
        ArrayList<StoreDependencyGraph.NodeLevel> ordering = Lists.newArrayListWithCapacity(wrappers.size());
        while (!topQueue.isEmpty()) {
            TopoNodeWrapper nw = (TopoNodeWrapper)topQueue.poll();
            ordering.add(nw.buildNodeLevel());
            for (TopoNodeWrapper nwn : nw.neighbors) {
                --nwn.depsCnt;
                nwn.level = nw.level + 1;
                if (nwn.depsCnt != 0) continue;
                topQueue.add(nwn);
                wrappers.remove(nwn);
            }
        }
        if (!wrappers.isEmpty()) {
            throw new IllegalStateException("Sorted only " + ordering.size() + " nodes. " + wrappers.size() + " nodes left: " + Collections2.transform(wrappers, input -> input.node));
        }
        return ordering;
    }

    @Nullable
    private Collection<Map<List<MttEdge>, Double>> getMttCells(SdgNode sourceNode, Collection<? extends SdgNode> destinationNodes) {
        this.ensureMtt();
        Map<SdgNode, Map<List<MttEdge>, Double>> row = this.mtts.row(sourceNode);
        if (row == null) {
            return null;
        }
        if (!(destinationNodes instanceof Set) && destinationNodes.size() > 1) {
            destinationNodes = new HashSet<SdgNode>(destinationNodes);
        }
        return Maps.filterKeys(row, Predicates.in(destinationNodes)).values();
    }

    double getMttQty(SdgNode sourceNode, Material material, Collection<? extends SdgNode> destinationNodes) {
        Collection<Map<List<MttEdge>, Double>> cells = this.getMttCells(sourceNode, destinationNodes);
        if (cells == null) {
            return 0.0;
        }
        double qty = 0.0;
        for (Map<List<MttEdge>, Double> cell : cells) {
            for (Map.Entry<List<MttEdge>, Double> entry : cell.entrySet()) {
                List<MttEdge> edges = entry.getKey();
                if (edges.isEmpty() || !Objects.equals(material, edges.get(0).getMat())) continue;
                qty += entry.getValue().doubleValue();
            }
        }
        return qty;
    }

    double getMttQty(SdgNode sourceNode, Collection<? extends SdgNode> destinationNodes) {
        Collection<Map<List<MttEdge>, Double>> cells = this.getMttCells(sourceNode, destinationNodes);
        if (cells == null) {
            return 0.0;
        }
        double qty = 0.0;
        for (Map<List<MttEdge>, Double> cell : cells) {
            for (Double value : cell.values()) {
                qty += value.doubleValue();
            }
        }
        return qty;
    }

    Set<SdgNode> getMttRelated(SdgNode node, StoreDependencyGraph.Direction direction) {
        this.ensureMtt();
        return (switch (direction) {
            case StoreDependencyGraph.Direction.TO_SOURCES -> this.mtts.column(node);
            case StoreDependencyGraph.Direction.TO_FINALS -> this.mtts.row(node);
            default -> throw new IllegalStateException();
        }).keySet();
    }

    private synchronized void ensureMtt() {
        if (this.mtts == null) {
            this.mtts = this.computeMtt();
        }
    }

    @VisibleForTesting
    Table<SdgNode, SdgNode, Map<List<MttEdge>, Double>> computeMtt() {
        return new MttComputer(this).computeMtt();
    }

    private static class TopoSortKeyExtractor
    implements SdgNodeVisitor<Tuple<Long, String>> {
        private TopoSortKeyExtractor() {
        }

        Tuple<Long, String> getSortKey(SdgNode node) {
            return node.accept(this);
        }

        @Override
        public Tuple<Long, String> visit(SdgSrNode node) {
            return Tuple.create(node.getSupplyRequest().getTime(), node.getSupplyRequest().getId());
        }

        @Override
        public Tuple<Long, String> visit(SdgCrNode node) {
            return Tuple.create(node.getCustomerRequest().getTime(), node.getCustomerRequest().getId());
        }

        @Override
        public Tuple<Long, String> visit(SdgGorNode node) {
            return Tuple.create(node.getGor().getEndDate(), node.getGor().getId());
        }

        @Override
        public Tuple<Long, String> visit(SdgGarNode node) {
            return Tuple.create(node.getGar().getEndDate(), ProductionTreeAlgorithms.getNearestGor(node.getGar()).getId() + node.getGar().getAction().getName());
        }

        @Override
        public Tuple<Long, String> visit(SdgEsaNode node) {
            return Tuple.create(node.getEsa().getTime(), node.getEsa().getMaterial().getId());
        }

        @Override
        public Tuple<Long, String> visit(SdgMatprodNode node) {
            return Tuple.create(Long.MAX_VALUE, node.getMatprod().getId());
        }
    }

    private static class TopoNodeWrapper {
        final SdgNode node;
        int level;
        int depsCnt;
        ImmutableList<TopoNodeWrapper> neighbors;
        final long sortTime;
        final String sortId;

        TopoNodeWrapper(SdgNode node, TopoSortKeyExtractor extractor) {
            this.node = node;
            this.level = 1;
            this.depsCnt = 0;
            Tuple<Long, String> sortKey = extractor.getSortKey(node);
            this.sortTime = sortKey.getFirst();
            this.sortId = sortKey.getSecond();
        }

        void setNeighbors(Collection<TopoNodeWrapper> neighbors) {
            this.neighbors = ImmutableList.copyOf(neighbors);
            for (TopoNodeWrapper neighbor : neighbors) {
                ++neighbor.depsCnt;
            }
        }

        StoreDependencyGraph.NodeLevel buildNodeLevel() {
            return new StoreDependencyGraph.NodeLevel(this.node, this.level);
        }
    }

    private static class TopoNodeWrapperComparator
    implements Comparator<TopoNodeWrapper> {
        private StoreDependencyGraph.Direction direction;

        private TopoNodeWrapperComparator(StoreDependencyGraph.Direction direction) {
            this.direction = direction;
        }

        @Override
        public int compare(TopoNodeWrapper o1, TopoNodeWrapper o2) {
            int cmp = Integer.compare(o1.level, o2.level);
            if (cmp != 0) {
                return cmp;
            }
            if (this.direction == StoreDependencyGraph.Direction.TO_SOURCES) {
                TopoNodeWrapper tmp = o1;
                o1 = o2;
                o2 = tmp;
            }
            if ((cmp = Long.compare(o1.sortTime, o2.sortTime)) != 0) {
                return cmp;
            }
            return o1.sortId.compareTo(o2.sortId);
        }
    }

    static final class InterGarMaterial
    extends Material {
        static final InterGarMaterial INSTANCE = new InterGarMaterial();
        static final String MAT_NAME = "$$IGM";

        private InterGarMaterial() {
            super((String)null);
        }

        @Override
        public String getName() {
            return MAT_NAME;
        }

        @Override
        @Nonnull
        public String getId() {
            return MAT_NAME;
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getMaterialHorizon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isConstant() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isConsumed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getMinBatch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getMaxBatch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getBatchStep() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getSafetyStock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getAggregationHorizon() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String formatHorizon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setProperties(Map<PropertyDefinition, String> properties, @Nonnull PropertyDefinitions definitions) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void resetProperties(@Nonnull Map<PropertyDefinition, Object> properties) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setProperty(@Nonnull PropertyDefinition pd, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getProperty(@Nonnull String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getProperty(@Nonnull PropertyDefinition def) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public Map<PropertyDefinition, Object> getProperties() {
            throw new UnsupportedOperationException();
        }
    }
}

